%% Do not* change anything in this file %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Backward Euler
% F(block1)=((dt)*A_cs-1)cs(t)+(dt)f_cs(cs(t))+cs(t-1)=0
% F(block2)=((dt)*A_ce-1)ce(t)+(dt)f_ce(cs(t))+ce(t-1)=0
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
function F_phis=bat_F_phis(y_in)
global eta tem sv sigmaEffFACE dx n_n n_s n_t n_p nr FARADAY RU...
       alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p i_app A_phis A jli
% settings_grid;
% settings_material;
% settings_atCnF;
N_np=n_n+n_p;
T=tem(1);
phiS=y_in(1:n_n+n_p);
conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
%% define BV equation
concS_max=zeros(1,n_t);concS_max(1:n_n)=concS_max_n;
concS_max(n_n+n_s+1:n_t)=concS_max_p;
kcon=zeros(1,n_t);kcon(1:n_n)=kcon_n;kcon(n_n+n_s+1:n_t)=kcon_p;
i0=kcon.*(conc.^alpha_a).*((concS_max-concS_surf).^alpha_a).*(concS_surf.^alpha_c);
exp1=exp((alpha_a * FARADAY/( RU * T ))* eta);
exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta);
jli=sv.*i0.*(exp1-exp2);
%% define jacobian matrix for Phis
%************************* define A_phis matrix **%%%**********************%
for k=1;
    A_phis_n(k,k)=-2*sigmaEffFACE(k+1)/(dx(k)+dx(k+1));
    A_phis_n(k,k+1)=2*sigmaEffFACE(k+1)/(dx(k)+dx(k+1));
end
for k=2:n_n-1
    left=2*sigmaEffFACE(k)/(dx(k)+dx(k-1));
    right=2*sigmaEffFACE(k+1)/(dx(k)+dx(k+1));
    A_phis_n(k,k-1)=2*sigmaEffFACE(k)/(dx(k)+dx(k-1));
    A_phis_n(k,k)=-(left+right);
    A_phis_n(k,k+1)=2*sigmaEffFACE(k+1)/(dx(k)+dx(k+1));
end
for k=n_n;
    A_phis_n(k,k-1)=2*sigmaEffFACE(k)/(dx(k)+dx(k-1));
    A_phis_n(k,k)=-2*sigmaEffFACE(k)/(dx(k)+dx(k-1));
end
for k=1;
    i=k+n_s+n_n;
    A_phis_p(k,k)=-2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
    A_phis_p(k,k+1)=2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
end
for k=2:n_p-1
    i=k+n_s+n_n;
    left=2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
    right=2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
    A_phis_p(k,k-1)=left;
    A_phis_p(k,k)=-(left+right);
    A_phis_p(k,k+1)=right;
end

for k=n_p;
    i=k+n_n+n_s;
    A_phis_p(k,k-1)=2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
    A_phis_p(k,k)=-2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
end
A_phis(1:n_n,1:n_n)=A_phis_n;
A_phis(n_n+1:N_np,n_n+1:N_np)=A_phis_p;

for k=1:n_t
    fphis(k)=jli(k)*dx(k);
end
f_phis=[fphis(1:n_n) fphis(n_n+n_s+1:n_n+n_s+n_p)]';
ba=zeros(n_n+n_p,1);
ba(1)=i_app/A;
ba(end)=-i_app/A;
%%
%************************ calculate F functions **************************%
F_phis=A_phis*(phiS')-f_phis+(ba);






